%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      ProcessImage.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% Description:    This file performs post-processing on the image
%-------------------------------------------------------------------------------

%[L,sensorLocs] = sensorCCM(vcGetObject('sensor'),'macbeth');

sensorLocs = ...
   [94     1
    93   126
    10   126
     9     1];
[L,sensorLocs] = sensorCCM(vcGetObject('sensor'),'macbeth',sensorLocs);


vci = vcImageCreate;
vci = imageSet(vci,'scaledisplay',1);
vci = imageSet(vci,'renderGamma',0.6);

% Use the linear transformation derived from sensor space (above) to
% display the RGB image in the processor window.
vci = imageSet(vci,'colorConversionTransform',L);
vci = imageSet(vci,'colorBalanceTransform',[]);% 
vci = imageSet(vci,'ics2displayTransform',[]);  % ICS 2 display
vci = imageSet(vci,'colorConversionMethod','Current matrix');
vci = imageSet(vci,'internalCS','Sensor');

% First, compute with the default properties.  This uses bilinear
% demosaicing, no color conversion or balancing.  The sensor RGB values are
% simply set to the display RGB values.
vci = vcimageCompute(vci,sensor);
vcAddAndSelectObject(vci);

% To be compatible with older code (remove later)
vci2 = vci;

if showISET == TRUE,
   vcimageWindow;
end

% End of File
